/*
 
 File: ViewController.m
 Abstract: Main View and all methods for interacting with Genesys Mobile Services
 
 Version: 1.0
 
 Disclaimer: IMPORTANT:  This sample software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Genesys Inc. All Rights Reserved.
 
 */

#import "ViewController.h"
#import <QuartzCore/QuartzCore.h>
#import "UIAlertViewContext.h"
//#import "JSONKit.h" //for iOS versions below 5 only 

@implementation ViewController

@synthesize txtScenario;
@synthesize btnGo;

@synthesize txtRequest;
@synthesize txtResponse;

@synthesize pkScenarios;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    appDelegate = (AppDelegate *) [[UIApplication sharedApplication] delegate];
    
    //Add this as an observer for push notifications from GMS
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(notify:) name:NSGMSServerNotification object:nil];

    txtScenario.inputView = pkScenarios;
    
    txtRequest.clipsToBounds = YES;
    txtRequest.layer.cornerRadius = 10.0f;
    
    txtResponse.clipsToBounds = YES;
    txtResponse.layer.cornerRadius = 10.0f;
    
    //Load Scenarios
    NSString *path = [[NSBundle mainBundle] pathForResource:@"scenarios" ofType:@"plist"];
    NSDictionary *scenarios = [NSDictionary dictionaryWithContentsOfFile:path];
    
    scenarioNames = [(NSArray *) [scenarios objectForKey:@"Scenarios"] retain];
    serviceAliases = [(NSArray *) [scenarios objectForKey:@"ServiceAliases"] retain];
    
    txtScenario.text = [scenarioNames objectAtIndex:0];
    currentRequest = [serviceAliases objectAtIndex:0];
    currentScenario = 0;
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

-(IBAction)doScenario:(id)sender {
    [self dismissInputView];
    txtRequest.text = @"";
    txtResponse.text = @"";
        
    if ((appDelegate.gmsURL != nil) && (appDelegate.userANI != nil)) {
        currentRequest = (NSString *) [serviceAliases objectAtIndex:currentScenario];
        NSString *gmsHost = [NSString stringWithFormat:@"%@/genesys/%@/service/%@", appDelegate.gmsURL,appDelegate.gmsVersion, currentRequest];
        NSURL *gmsUrl = [NSURL URLWithString:gmsHost];
        NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:gmsUrl
                                                               cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                           timeoutInterval:60.0];
        
        [request setHTTPMethod:@"POST"];
        [request setValue:@"multipart/form-data;boundary=AaB03x" forHTTPHeaderField:@"Content-Type"];
        [request setValue:@"application/json" forHTTPHeaderField:@"Accept"];
        
        
        NSString *boundary = @"--AaB03x\r\nContent-Disposition: form-data; name="; //Multipart form boundary
        NSMutableString *requestBody = [[[NSMutableString alloc] init] autorelease];
        
        [requestBody appendFormat:@"%@_phone_number\r\n\r\n%@\r\n", boundary, appDelegate.userANI]; //Phone number
        [requestBody appendFormat:@"%@_provide_code\r\n\r\ntrue\r\n", boundary]; //Use DTMF Codes
        
        CLLocationManager *locationManager = appDelegate.locationManager;
        CLLocationCoordinate2D location = [locationManager location].coordinate;
        
        [requestBody appendFormat:@"%@_current_location_latitude\r\n\r\n%@\r\n", boundary, [NSString stringWithFormat:@"%f", location.latitude]]; //Phone number
        [requestBody appendFormat:@"%@_current_location_longitude\r\n\r\n%@\r\n", boundary, [NSString stringWithFormat:@"%f", location.longitude]]; //Use DTMF Codes
        
        [requestBody appendFormat:@"%@device_language\r\n\r\n%@\r\n", boundary, [[NSLocale preferredLanguages] objectAtIndex:0]]; //Language
        [requestBody appendFormat:@"%@_country_code\r\n\r\n%@\r\n", boundary, [[NSLocale currentLocale] objectForKey:NSLocaleCountryCode]]; //Country Code
        
        if ([txtScenario.text isEqualToString:SCENARIO_ADVANCED_ASYNC] || [txtScenario.text isEqualToString:SCENARIO_ENTERPRISE_INITIATED_ASYNC]) {
            [requestBody appendFormat:@"%@_device_notification_id\r\n\r\n%@\r\n", boundary, appDelegate.notifyToken]; //Language
            [requestBody appendFormat:@"%@_device_os\r\n\r\niOS\r\n", boundary]; //Device OS            
        }
        
        //You can insert your business object as serialized JSON using a suitable library such as SBJSon or Restkit
        //You can also use Restkit to append images as part of the multipart form request using NSData
        
        [requestBody appendString:@"--AaB03x--"];
        [request setHTTPBody:[requestBody dataUsingEncoding:NSUTF8StringEncoding]];
        txtRequest.text = requestBody;
        
        //Connect and Post
        gmsConnection= [[NSURLConnection alloc] initWithRequest:request 
                                                       delegate:self];
        if (gmsConnection) {
            gmsResponse = [[NSMutableData data] retain];
        }
    }
    else {
        UIAlertView *alert = [[[UIAlertView alloc]
                               initWithTitle: @"Settings Incomplete"
                               message: @"Please fill in all details in settings"
                               delegate: nil
                               cancelButtonTitle:@"OK"
                               otherButtonTitles:nil] autorelease];
        [alert show];
    } 
}

#pragma mark - NSURLConnectionDelegate methods

-(void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response{
    [gmsResponse setLength: 0];
}

-(void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)data{
    [gmsResponse appendData:data];
}

-(void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error{
    UIAlertView *alert = [[[UIAlertView alloc]
                          initWithTitle: @"There was an error connecting to GMS"
                          message: [error localizedDescription]
                          delegate: nil
                          cancelButtonTitle:@"OK"
                          otherButtonTitles:nil] autorelease];
    [alert show];
    [connection release], connection = nil;
    [gmsResponse setLength:0];
    currentRequest = nil;
}

- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{    
    // do something with the data
    txtResponse.text = [[[NSString alloc] initWithData:gmsResponse
                                             encoding:NSUTF8StringEncoding] autorelease];
    NSLog(@"Response for %@\n\n%@", currentRequest, txtResponse.text);
    
    if ([currentRequest isEqualToString:REQUEST_ACCEPT]) { //No further processing required for Enterprise initiated accept requests
        return;
    }
    
    Class jsonSerializationClass = NSClassFromString(@"NSJSONSerialization");
    NSError *error = nil;
    NSDictionary *jsonResponse = nil;
    if (!jsonSerializationClass) {
        //JSON Serialization is built into iOS 5. For earlier versions, you can use a suitable JSON Parser like JSonKit 
        //jsonResponse = [gmsResponse objectFromJSONData];
        
        UIAlertView *alert = [[[UIAlertView alloc]
                               initWithTitle: @"Older iOS Version"
                               message: @"This sample will work only on iOS 5 and higher"
                               delegate: nil
                               cancelButtonTitle:@"OK"
                               otherButtonTitles:nil] autorelease];
        [alert show];
        return;
    }
    else {
        jsonResponse = [jsonSerializationClass JSONObjectWithData:gmsResponse options:NSJSONWritingPrettyPrinted error:&error];
    }
    
    if (jsonResponse == nil) {
        NSLog(@"ERROR parsing response from GMS...%@", error);
        UIAlertView *alert = [[[UIAlertView alloc]
                               initWithTitle: @"Error receiving response"
                               message: @"Invalid response from GMS"
                               delegate: nil
                               cancelButtonTitle:@"OK"
                               otherButtonTitles:nil] autorelease];
        [alert show];
        return;
    }
    
    // release the connection, and the data object
    [connection release], connection = nil;
    [gmsResponse release], gmsResponse = nil;
    
    if ([currentRequest isEqualToString:POLL_AGENT]) {
        [self didReceiveServerEvent:jsonResponse];
        return;
    }

    if ([txtScenario.text isEqualToString:SCENARIO_BASIC_MATCH] || [txtScenario.text isEqualToString:SCENARIO_ADVANCED_SYNC]) {
        NSString *accessNumber = (NSString *) [jsonResponse objectForKey:@"_access_number"];
        NSString *accessCode = (NSString *) [jsonResponse objectForKey:@"_access_code"];
        NSString *objectId = (NSString *) [jsonResponse objectForKey:@"_id"];
    
        if (accessNumber == nil) {
            UIAlertView *alert = [[[UIAlertView alloc]
                                  initWithTitle: @"Error receiving call-in details"
                                  message: @"No access number received"
                                  delegate: nil
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil] autorelease];
            [alert show];
            return;
        }
    
        if (objectId == nil) {
            UIAlertView *alert = [[[UIAlertView alloc]
                                  initWithTitle: @"Error submitting request"
                                  message: @"No service case id received"
                                  delegate: nil
                                  cancelButtonTitle:@"OK"
                                  otherButtonTitles:nil] autorelease];
            [alert show];
            return;
        }
        
        if (accessCode != nil) 
            accessNumber = [NSString stringWithFormat:@"tel:%@,,%@", accessNumber, accessCode];
        else
            accessNumber = [NSString stringWithFormat:@"tel:%@", accessNumber];
    
        [self.navigationController popViewControllerAnimated:YES];
    
        UIAlertViewContext *alert = [[UIAlertViewContext alloc] init]; //Subclassed UIAlertview to include a context object
        [alert setTitle:@"Request successfully submitted"];
        [alert setMessage:@"Do you wish to speak to an agent?"];        
        [alert setDelegate:self];
        [alert setContext:[NSURL URLWithString:accessNumber]];
        [alert addButtonWithTitle:@"Yes"];
        [alert addButtonWithTitle:@"No"];
        [alert show];            
    }
    else if (([txtScenario.text isEqualToString:SCENARIO_ADVANCED_ASYNC] && ![currentRequest isEqualToString:RESERVE_AGENT]) 
             || [txtScenario.text isEqualToString:SCENARIO_ENTERPRISE_INITIATED] 
             || ([txtScenario.text isEqualToString:SCENARIO_ENTERPRISE_INITIATED_ASYNC] && ![currentRequest isEqualToString:REQUEST_ACCEPT])) {
        //In this scenario, you just receive the ID back
        //You then wait for push notifications to denote when an agent becomes available in advanced async
        //Or you wait for a call in the enterprise initiated scenario.
                
        NSString *objectId = (NSString *) [jsonResponse objectForKey:@"_id"];
        //You can update your business object using the ID that is returned
        //In this example we will just log the ID
        NSLog(@"Service Case Id = %@", objectId);
    }
    else if ([txtScenario.text isEqualToString:SCENARIO_ADVANCED_POLL] && ![currentRequest isEqualToString:RESERVE_AGENT]) {
        //In this scenario, you poll the server until an agent becomes available
        
        NSString *objectId = (NSString *) [jsonResponse objectForKey:@"_id"];
        //You can update your business object using the ID that is returned
        //In this example we will just log the ID
        NSLog(@"Service Case Id = %@", objectId);
        
        [self pollAgentAvailability:objectId];
    }
    else if ([currentRequest isEqualToString:RESERVE_AGENT]) { //Reserve agent when notified that the agent is available
        NSString *accessNumber = (NSString *) [jsonResponse objectForKey:@"_access_number"];
        NSString *accessCode = (NSString *) [jsonResponse objectForKey:@"_access_code"];
        NSString *agentAccessNumber = nil;
        
        if (accessCode != nil) 
            agentAccessNumber = [NSString stringWithFormat:@"tel:%@,,%@", accessNumber, accessCode];
        else {
            agentAccessNumber = [NSString stringWithFormat:@"tel:%@", accessNumber];
        } 
        
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:agentAccessNumber]];            
    }
    
    //currentRequest = nil;
}

#pragma mark - Notification methods

- (void)notify:(NSNotification *)notification {
	NSDictionary *userInfo = [notification userInfo];
    [self didReceiveServerEvent:userInfo];
}

-(void)didReceiveServerEvent:(NSDictionary *)serverEvent {
    NSDictionary *message = nil;
    NSError *error;
    
    if ((currentRequest != nil) && [currentRequest isEqualToString:POLL_AGENT]) {
        message = (NSDictionary *) [serverEvent objectForKey:@"message"];
    }
    else {    
        //Ideally the whole push message would be JSOn and you can serialize the whole message
        //But due to various quirks, the message field contains JSON as a string
        NSString *json = (NSString *) [serverEvent objectForKey:@"message"];
        NSData* jsonData=[json dataUsingEncoding:NSUTF8StringEncoding];
    
        //JSON Serialization is built into iOS 5. For earlier versions, you can use a suitable JSON Parser like SBJSON
        message = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONWritingPrettyPrinted error:&error];

    }
    
    if (message == nil) {
        NSLog(@"ERROR parsing message from GMS");
        if (error != nil)
            txtRequest.text = [error localizedDescription];
        return;
    }
    
    NSString *status = [message objectForKey:@"_status"];
    NSString *objectID = [message objectForKey:@"_id"];
    
    //An Agent is available, reserve the agent
    if ([status isEqualToString:STATUS_AGENT_AVAILABLE] || [status isEqualToString:STATUS_ACCEPT]) {                
        UIAlertViewContext *alert = [[UIAlertViewContext alloc] init];
        [alert setTitle:@"An agent is now available"];
        [alert setMessage:@"Do you wish to speak to the agent?"];    
        
        [alert setDelegate:self];
        [alert setContext:objectID];
        [alert setGmsState:status];
        [alert addButtonWithTitle:@"Yes"];
        [alert addButtonWithTitle:@"No"];
        [alert show];        
    }
    else if ([txtScenario.text isEqualToString:SCENARIO_ADVANCED_POLL]) {
        [self pollAgentAvailability:objectID];
    }
}

- (void) pollAgentAvailability:(NSString *)objectID {
    currentRequest = POLL_AGENT;
    NSString *gmsHost = [NSString stringWithFormat:@"%@/genesys/%@/service/%@/%@", appDelegate.gmsURL,appDelegate.gmsVersion, objectID, currentRequest];
    NSLog(@"%@", gmsHost);
    NSURL *gmsUrl = [NSURL URLWithString:gmsHost];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:gmsUrl
                                                           cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                       timeoutInterval:60.0];
    
    [request setHTTPMethod:@"POST"];
    [request setValue:@"multipart/form-data;boundary=AaB03x" forHTTPHeaderField:@"Content-Type"];
    [request setValue:@"application/json" forHTTPHeaderField:@"Accept"];
    
    NSString *boundary = @"--AaB03x\r\nContent-Disposition: form-data; name="; //Multipart form boundary
    NSMutableString *requestBody = [[[NSMutableString alloc] init] autorelease];
    
    [requestBody appendFormat:@"%@_provide_code\r\n\r\ntrue\r\n", boundary]; //Use DTMF Codes
    
    [requestBody appendString:@"--AaB03x--"];
    [request setHTTPBody:[requestBody dataUsingEncoding:NSUTF8StringEncoding]];
    txtRequest.text = requestBody;
    NSLog(@"%@", requestBody);
    
    //Connect and Post
    gmsConnection= [[NSURLConnection alloc] initWithRequest:request 
                                                   delegate:self];
    if (gmsConnection) {
        gmsResponse = [[NSMutableData data] retain];
    }    
}

#pragma mark - UIAlertViewDelegate methods

- (void)alertView:(UIAlertViewContext *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
	if (buttonIndex == 0) //Yes
	{
        //In the basic scenario, we receive a tel URI. Open the URL to place a call
        if ([txtScenario.text isEqualToString:SCENARIO_BASIC_MATCH] || [txtScenario.text isEqualToString:SCENARIO_ADVANCED_SYNC]) {
            NSURL *accessNumber = (NSURL *)[alertView context];
            NSLog(@"Calling %@", accessNumber);
            [[UIApplication sharedApplication] openURL:accessNumber];
        }
        else if ([txtScenario.text isEqualToString:SCENARIO_ADVANCED_ASYNC] || [txtScenario.text isEqualToString:SCENARIO_ENTERPRISE_INITIATED_ASYNC]
                 || [txtScenario.text isEqualToString:SCENARIO_ADVANCED_POLL]) {
            // This is the advanced scenario. Reserve agent
            NSString *objectID = (NSString *) [alertView context];
            if ([[alertView gmsState] isEqualToString:STATUS_AGENT_AVAILABLE])
                currentRequest = RESERVE_AGENT;
            else if ([[alertView gmsState] isEqualToString:STATUS_ACCEPT]) {
                currentRequest = REQUEST_ACCEPT;
            }
            NSString *gmsHost = [NSString stringWithFormat:@"%@/genesys/%@/service/%@/%@", appDelegate.gmsURL,appDelegate.gmsVersion, objectID, currentRequest];
            NSLog(@"%@", gmsHost);
            NSURL *gmsUrl = [NSURL URLWithString:gmsHost];
            NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:gmsUrl
                                                                   cachePolicy:NSURLRequestUseProtocolCachePolicy
                                                               timeoutInterval:60.0];
            
            [request setHTTPMethod:@"POST"];
            [request setValue:@"multipart/form-data;boundary=AaB03x" forHTTPHeaderField:@"Content-Type"];
            [request setValue:@"application/json" forHTTPHeaderField:@"Accept"];
            
            NSString *boundary = @"--AaB03x\r\nContent-Disposition: form-data; name="; //Multipart form boundary
            NSMutableString *requestBody = [[[NSMutableString alloc] init] autorelease];
            
            [requestBody appendFormat:@"%@_provide_code\r\n\r\ntrue\r\n", boundary]; //Use DTMF Codes
                        
            [requestBody appendString:@"--AaB03x--"];
            [request setHTTPBody:[requestBody dataUsingEncoding:NSUTF8StringEncoding]];
            txtRequest.text = requestBody;
            NSLog(@"%@", requestBody);
            
            //Connect and Post
            gmsConnection= [[NSURLConnection alloc] initWithRequest:request 
                                                                          delegate:self];
            if (gmsConnection) {
                gmsResponse = [[NSMutableData data] retain];
            }
        }
	}
	else if (buttonIndex == 1)
	{
		// No
	}
}

-(void)dismissInputView {
    [txtRequest resignFirstResponder];
    [txtResponse resignFirstResponder];
    [txtScenario resignFirstResponder];
}

#pragma mark - UIPickerViewDelegate
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView;
{
    return 1;
}

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    txtScenario.text= [scenarioNames objectAtIndex:row];
    currentRequest = [serviceAliases objectAtIndex:row];
    [txtScenario resignFirstResponder];
    txtRequest.text = @"";
    txtResponse.text = @"";
    currentScenario = row;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component;
{
    return [scenarioNames count];
}

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component;
{
    return [scenarioNames objectAtIndex:row];
}

@end
